"""
HB_SymmetryFix V1.1

Last Modified: Oct/11/2018
Works with CINEMA 4D R16-R20 and up.
Copyright: Holger Biebrach, www.c4dstuff.com

Name-US: HB_SymmetryFix
Description-US: Centers Points to the YZ-Plane to fix Symmetry [SHIFT: Use Tolerance instead of Pointselection]

Video Tutorial:
https://youtu.be/Ki6I9sRdeUU?t=40m30s
https://youtu.be/UlY-X5O137M?t=730

ChangeLog:
Jun/11/2015 V1.0
- Release Version

Oct/11/2018 V1.1
- Python Rewrite
- Selected Points or Edges
- SHIFT-Mode to use Tolerance
- Multiple Objects
- New Highres Icon

"""

import c4d
from c4d import utils, gui


def CenterPoints(obj):

    sel = obj.GetAllPoints()
    pnts = c4d.BaseSelect()
    pnts.DeselectAll()
    points = [(i, point)
          for i, point in enumerate(obj.GetAllPoints())
          ]

    if not points:
      return
    sel = obj.GetPointS()
    sel.DeselectAll()

    for i, point in points:
      pos=obj.GetPoint(i)
      xpos=pos.x


      if xpos < float(tolerance):

          obj.SetPoint(i,c4d.Vector(0,pos.y,pos.z))

    
    obj.Message(c4d.MSG_UPDATE)




def CenterAllSelectedPoints(obj):

    if not obj.CheckType(c4d.Opoint):
      return

    sel = obj.GetPointS()
    points = [(i, point)
          for i, point in enumerate(obj.GetAllPoints())
          if sel.IsSelected(i)]

    if not points:
      return

    for i, point in points:
        pos=obj.GetPoint(i)
        obj.SetPoint(i,c4d.Vector(0,pos.y,pos.z))

    obj.Message(c4d.MSG_UPDATE)




def main():
    global tolerance 
    
    bc = c4d.BaseContainer()
    c4d.gui.GetInputState(c4d.BFM_INPUT_KEYBOARD,c4d.BFM_INPUT_CHANNEL,bc)
         
    tolerance = 1      
    activeobjects = doc.GetActiveObjects(c4d.GETACTIVEOBJECTFLAGS_CHILDREN) 
           
    if bc[c4d.BFM_INPUT_QUALIFIER] ==1 : #SHIFT: Open Dialog and use Tolerance
        print "SHIFT"

        tolerance = gui.InputDialog("Tolerance", 1)
    
        
        for obj in activeobjects:
            doc.AddUndo(c4d.UNDOTYPE_CHANGE, obj)
            CenterPoints(obj)
    
    else:

        for obj in activeobjects:
            
            
            if doc.GetMode()==6: # is EdgeMode active? Run selction Command
                ConvertSettings = c4d.BaseContainer() 
     
                ConvertSettings[c4d.MDATA_CONVERTSELECTION_LEFT]=1
                ConvertSettings[c4d.MDATA_CONVERTSELECTION_RIGHT]=0    
        
                c4d.utils.SendModelingCommand(command = c4d.MCOMMAND_CONVERTSELECTION,
                                            list = [obj],
                                            mode = c4d.MODELINGCOMMANDMODE_EDGESELECTION,
                                            bc = ConvertSettings,
                                            doc = doc)
                
            doc.AddUndo(c4d.UNDOTYPE_CHANGE, obj)
            CenterAllSelectedPoints(obj)
        
    

        
    c4d.EventAdd()

    
    
     

if __name__=='__main__':
    main()
